(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     93416,       2383]
NotebookOptionsPosition[     88978,       2295]
NotebookOutlinePosition[     89374,       2311]
CellTagsIndexPosition[     89331,       2308]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Equiorthodiagonal  Quadrilaterals - vertex centroid", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, {
  3.947144439694456*^9, 3.947144443366682*^9}, {3.947339713636549*^9, 
  3.947339717251663*^9}, {3.954728574674156*^9, 3.954728576840864*^9}, {
  3.9547551538092933`*^9, 3.954755163713123*^9}, {3.955500217270401*^9, 
  3.9555002226327972`*^9}, {3.9555002766159*^9, 
  3.955500279423851*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about equi-orthodiagonal \
quadrilaterals in the paper \[OpenCurlyDoubleQuote]More Shapes of Central \
Quadrilaterals\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in July \
2025.

This Notebook is Copyright \[Copyright] July 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947148657900776*^9, 3.947148664004244*^9}, {
  3.947339725299139*^9, 3.947339727179648*^9}, {3.954754697225456*^9, 
  3.954754702049347*^9}, {3.961412550018305*^9, 
  3.9614125580896893`*^9}},ExpressionUUID->"22c83543-03f0-524a-b077-\
52bf40ea5d06"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptD", "=", 
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], ";"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"condition", " ", "for", " ", "orthodiagonal", " ", "quad"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"ortho", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Perpendicular", "[", 
     RowBox[{"ptB", ",", "rtCA"}], "]"}], ".", "ptD"}], "==", 
   "0"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471447897267284`*^9, 3.9471448143356647`*^9}, {3.947339795568245*^9, 
   3.9473398095558796`*^9}, {3.9547552492897663`*^9, 3.954755284434631*^9}},
 CellLabel->
  "In[118]:=",ExpressionUUID->"74888ac6-8629-5b49-901d-61a6ce2212ce"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "r"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{3.947339807338928*^9, 3.947339859159481*^9, 
  3.947339905318266*^9, 3.947339989147003*^9, 3.947376863375458*^9, 
  3.947377688860035*^9, 3.947399223530634*^9, 3.9475699928518295`*^9, 
  3.954731828747135*^9, 3.954755798278473*^9, 3.954757132919309*^9, 
  3.955500472388457*^9, 3.955502255215103*^9, 3.9611143840890274`*^9, 
  3.9611147733573117`*^9, 3.9611187125383587`*^9, 3.9614125907075663`*^9},
 CellLabel->
  "Out[121]=",ExpressionUUID->"cfd51ebc-bbe5-4c04-a930-cd8f43dc74cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"condition", " ", "for", " ", "equidiagonal", " ", "quad"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"equi", "=", 
   RowBox[{"Eliminate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "==", "b"}], ",", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "==", 
        RowBox[{"CuadradoDistancia", "[", 
         RowBox[{"ptB", ",", "ptD"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", "u", "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.947339867867523*^9, {3.954755289456901*^9, 3.954755297218359*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"b85875b1-0f4d-224e-8941-3643f1b38130"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["p", "2"]}], "-", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SuperscriptBox["p", "2"]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["q", "2"]}], "-", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "-", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["r", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["r", "2"]}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.947339865550669*^9, 3.947339868551458*^9}, 
   3.947339905342198*^9, 3.9473399891699715`*^9, 3.9473768637187634`*^9, 
   3.947377688882963*^9, 3.94739922387187*^9, 3.947569993193884*^9, {
   3.954731823939247*^9, 3.9547318287701416`*^9}, 3.954755798465472*^9, 
   3.95475713293631*^9, 3.9555004725604553`*^9, 3.955502255234108*^9, 
   3.9611143868387585`*^9, 3.961114773375326*^9, 3.9611187125633106`*^9, 
   3.961412590788001*^9},
 CellLabel->
  "Out[122]=",ExpressionUUID->"4a33946f-97f1-420f-8fb0-57ddb229e215"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"assume", " ", "ABCD", " ", "convex", " ", "so", " ", "angle", 
     RowBox[{"(", "ACB", ")"}]}], "<", " ", 
    RowBox[{"90", "\[Degree]"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "coordinates", " ", "of", " ", "point", " ", "D", " ", "of", " ", "an", " ",
      "equi"}], "-", 
    RowBox[{"orthodiagonal", " ", "quadrilateral", " ", "ABCD"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"ptD", "=", 
   RowBox[{"Last", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"Simplificar", ",", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"p", ",", "q", ",", "r"}], "}"}], "/.", 
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"ortho", ",", "equi"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"q", ",", "r"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"p", ">", "0"}], ",", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ">", "0"}]}], "}"}]}], "]"}]}], 
      "]"}], "/.", 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}]], "->", 
      RowBox[{"2", "S"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.947339815820603*^9, 3.947339861421566*^9}, 
   3.947380060869086*^9, {3.947381792148802*^9, 3.947381796403881*^9}, {
   3.947384060266676*^9, 3.947384094395052*^9}, {3.961118843622614*^9, 
   3.961118896224457*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"9b5c50c2-12e8-2e4e-a83c-2c0c274b0519"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"2", " ", "S"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9473398297352505`*^9, 3.947339905370121*^9}, 
   3.9473399891958714`*^9, 3.9473768639394455`*^9, 3.947377688913883*^9, 
   3.9473800620104985`*^9, 3.947381797495817*^9, 3.947399224103514*^9, 
   3.947569993384405*^9, 3.954731829002188*^9, 3.954731989355959*^9, 
   3.954755798653469*^9, 3.954757132976309*^9, 3.955500472834957*^9, 
   3.9555022552641106`*^9, 3.96111440357135*^9, 3.96111477349231*^9, 
   3.961118712768343*^9, 3.961412591084717*^9},
 CellLabel->
  "Out[123]=",ExpressionUUID->"a29b3c23-e089-4808-aaf4-f79ed13a591a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"8108185d-0476-624f-aca1-\
9531401fcf8c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "central", " ", "quadrilateral", " ", "of", " ", "ABCD", " ", "wrt", " ", 
     "a", " ", "point", " ", "E"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"n_Integer", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{
           RowBox[{"ETC", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "]"}], 
        "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX_", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "vertex", " ", "centroid", " ", "of", " ", "a", " ", "quadrilateral"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centroidQuad", "[", 
      RowBox[{"{", 
       RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
     RowBox[{"Punto", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{
         RowBox[{"Medio", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Medio", "[", 
          RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Recta", "[", 
        RowBox[{
         RowBox[{"Medio", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Medio", "[", 
          RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "tests", " ", "for", " ", "parallelism", " ", "and", " ", 
     "perpendicularity"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"parallelQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinito", "[", "r", "]"}], ".", "s"}], "]"}], "/.", 
         "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"perpendicularQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinitoPerpendicular", "[", 
            RowBox[{"PuntoInfinito", "[", "r", "]"}], "]"}], ".", "s"}], 
          "]"}], "/.", "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"tests", " ", "for", " ", "a", " ", "parallelogram"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"parallelogramQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptP_", ",", "ptQ_", ",", "ptR_", ",", "ptS_"}], "}"}], ",", 
      RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{"parallelQ", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"ptP", ",", "ptQ"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"ptR", ",", "ptS"}], "]"}], ",", "cond"}], "]"}], "&&", 
     RowBox[{"parallelQ", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"ptP", ",", "ptS"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"ptR", ",", "ptQ"}], "]"}], ",", "cond"}], "]"}]}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125156*^9}, {
   3.947133479684403*^9, 3.947133480044634*^9}, {3.954749394336471*^9, 
   3.954749396294033*^9}, {3.954750090329485*^9, 3.954750131865982*^9}, {
   3.954753612330324*^9, 3.954753613564296*^9}, 3.954753651040304*^9, {
   3.954753717466011*^9, 3.9547537696116104`*^9}, 3.954753823286117*^9, {
   3.9547539533955135`*^9, 3.954754007724783*^9}, {3.954754908348152*^9, 
   3.954754934396097*^9}, {3.9547585245539*^9, 3.954758530897945*^9}, {
   3.96111454918734*^9, 3.961114573516236*^9}, {3.9611146297779846`*^9, 
   3.961114632154564*^9}, {3.961118700554388*^9, 3.9611187015885715`*^9}, 
   3.9614125764354687`*^9},
 CellLabel->
  "In[124]:=",ExpressionUUID->"af857665-e69b-be41-831b-79c8778d303b"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQlcVFX//wf/lfiKR//UT//ZY6UPUT78NEvqMcwSMnF7kExRM8R9wxX3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    "], {{0, 98.49056603773585}, {668.3773584905659, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{668.3773584905659, 98.49056603773585},
  PlotRange->{{0, 668.3773584905659}, {0, 98.49056603773585}}]], "Text",
 CellChangeTimes->{3.9547289833023987`*^9, 
  3.9555005681217747`*^9},ExpressionUUID->"27562332-302c-684c-a6e9-\
c7f5988655e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptE", "=", 
  RowBox[{"centroidQuad", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"vertex", " ", "centroid", " ", "of", " ", "ABCD"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.954729517411064*^9, 3.954729545606804*^9}, {
  3.954754889196739*^9, 3.954754892674591*^9}, {3.954755094602075*^9, 
  3.9547551086826744`*^9}},
 CellLabel->
  "In[134]:=",ExpressionUUID->"92df2acf-ef77-6d4c-a144-72124269f2b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "-", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"], "-", 
    RowBox[{"2", " ", "S"}]}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"], "-", 
    RowBox[{"2", " ", "S"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.954729538170908*^9, 3.954729546305495*^9}, 
   3.954731754861231*^9, 3.954755109959696*^9, 3.95550061662553*^9, 
   3.9555022652927685`*^9, 3.9611146425012712`*^9, 3.9611187290890503`*^9, 
   3.9614125911612186`*^9},
 CellLabel->
  "Out[134]=",ExpressionUUID->"5fa46cb0-8b21-499a-af11-b98093368877"]
}, Open  ]],

Cell[CellGroupData[{

Cell["X (491) ", "Subsection",
 CellChangeTimes->{{3.9547317438609147`*^9, 3.954731748709286*^9}, 
   3.9555006250255566`*^9, {3.955500789850113*^9, 3.955500791522558*^9}, 
   3.9555025796256657`*^9},ExpressionUUID->"ecf6dcd3-cf0e-b645-870d-\
ac275961074f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X491", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"ETC", "[", 
     RowBox[{"[", 
      RowBox[{"491", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.955502432264721*^9, 3.955502509074981*^9}},
 CellLabel->
  "In[135]:=",ExpressionUUID->"241b988e-fc19-9b4b-a6d1-1396928f2f0b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"], "+", 
    RowBox[{"2", " ", "S"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"], "+", 
    RowBox[{"2", " ", "S"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], "-", 
    SuperscriptBox["b", "2"], "+", 
    SuperscriptBox["c", "2"], "+", 
    RowBox[{"2", " ", "S"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.955502441854812*^9, {3.955502483728218*^9, 3.955502509948002*^9}, 
   3.961114658687269*^9, 3.961114788849701*^9, 3.961118732658207*^9, 
   3.961412591167301*^9},
 CellLabel->
  "Out[135]=",ExpressionUUID->"eb9d6d0b-5579-4d48-908d-f8a328107238"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Simplificar", "[", 
      RowBox[{
       RowBox[{"Expand", "[", "#", "]"}], "/.", "sustS"}], "]"}], "&"}], ",", 
    RowBox[{"centralQuadrilateral", "[", 
     RowBox[{"X491", ",", "ptE"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.954729571311468*^9, 3.9547296004388103`*^9}, {
  3.954754997771496*^9, 3.954754997798126*^9}, {3.955500631370678*^9, 
  3.9555006314343357`*^9}, {3.955500819211632*^9, 3.9555008635231934`*^9}, {
  3.955502515262575*^9, 3.955502548891234*^9}, {3.955502592428831*^9, 
  3.955502659347826*^9}},
 CellLabel->
  "In[136]:=",ExpressionUUID->"ef7de7f6-c2df-024e-ac07-6e9790b96d26"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"10", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"17", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"22", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"21", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"7", " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "-", 
           RowBox[{"6", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{"10", " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"12", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"17", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "21"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"22", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"28", " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"34", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"15", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"32", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"28", " ", 
       SuperscriptBox["c", "2"], " ", "S"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "19"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"26", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{"5", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "15"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "5"}], " ", 
               SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"9", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{"14", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"34", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"24", " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "9"}], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"52", " ", "S"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"14", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"24", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"52", " ", 
       SuperscriptBox["c", "2"], " ", "S"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"34", " ", "S"}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "15"}], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"26", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "19"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"10", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}]}], ")"}]}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"15", " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"34", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"16", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"11", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"28", " ", "S"}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.954729575891878*^9, 3.9547296012302666`*^9}, 
   3.954729646954029*^9, 3.954731759231823*^9, 3.954755116825212*^9, 
   3.955500632376896*^9, {3.955500824761933*^9, 3.95550086467103*^9}, 
   3.955501190841278*^9, 3.955502275990225*^9, 3.9555023825972157`*^9, {
   3.955502531108748*^9, 3.955502550200241*^9}, 3.955502663108978*^9, 
   3.961114666003229*^9, 3.961114790763994*^9, 3.9611187349183445`*^9, 
   3.9614125920868692`*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"2b3a6a3d-ec4b-4ec8-abdb-122677b3bfc5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "FGHI", " ", "is", " ", "a", " ", "parallelogram", " ", "with", " ", 
    "IF"}], "||", " ", 
   RowBox[{"GH", " ", "and", " ", "IH"}], "||", " ", "GF"}], "*)"}]], "Input",
 CellChangeTimes->{{3.9611148401249323`*^9, 3.961114863887638*^9}, {
  3.9611189804846783`*^9, 3.961118983602148*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"3e17e663-ee42-e74d-a24f-f535dfbc3639"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptH"}], "]"}], ",", 
   RowBox[{"equi", "&&", "ortho"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.954729807859654*^9, 3.954729824503559*^9}, {
  3.954755009211235*^9, 3.954755013394407*^9}, {3.9547550467536907`*^9, 
  3.954755057026333*^9}, {3.954755133083036*^9, 3.95475513477508*^9}, {
  3.955500671562372*^9, 3.955500706962506*^9}, {3.955500738637953*^9, 
  3.9555007555221214`*^9}},
 CellLabel->
  "In[138]:=",ExpressionUUID->"17b3a835-0e2e-9e4e-8891-bb03c169344a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.954755124252447*^9, 3.954755136469471*^9}, 
   3.955500708760023*^9, 3.9555007579103203`*^9, 3.9555008698233166`*^9, 
   3.955501193407881*^9, 3.955502293702255*^9, 3.955502572416664*^9, 
   3.955502666855743*^9, 3.9611146981162014`*^9, 3.961114793402569*^9, 
   3.961412592442975*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"19536fad-b198-4249-bf8b-e050683a1d01"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptI", ",", "ptH"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptF"}], "]"}], ",", 
   RowBox[{"equi", "&&", "ortho"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.955502329258995*^9, 3.955502332247463*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"85d456ba-322b-b84d-9b69-1bb647470dfc"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.95550233392682*^9, 3.955502574714744*^9, 
  3.9555026685915203`*^9, 3.961114731443444*^9, 3.96111479495299*^9, 
  3.9614125927193127`*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"6eb70a26-9826-46b7-b624-9d9f255ebd92"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelogramQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.961118753754593*^9, 3.9611187660113945`*^9}},
 CellLabel->
  "In[140]:=",ExpressionUUID->"78fec985-6698-724b-913e-99ae9f85eb1e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611187679020844`*^9, 3.961412593207316*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"8cb6e1d8-d3c5-43e3-89b8-9db8e300a39a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["X (615)", "Subsection",
 CellChangeTimes->{{3.9547317438609157`*^9, 3.954731748709286*^9}, 
   3.9555006250255566`*^9, {3.955500786993265*^9, 
   3.955500787352442*^9}},ExpressionUUID->"1ed5f139-668c-f64b-a46b-\
7ef4cdeadc1e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"Map", "[", 
   RowBox[{"Simplificar", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"centralQuadrilateral", "[", 
       RowBox[{"615", ",", "ptE"}], "]"}], "/.", "sustC"}], "/.", "sustS"}]}],
    "]"}]}]], "Input",
 CellChangeTimes->{{3.954729571311468*^9, 3.9547296004388103`*^9}, {
  3.954754997771496*^9, 3.954754997798126*^9}, {3.955500631370678*^9, 
  3.9555006314343357`*^9}, {3.955500801156164*^9, 3.955500801953665*^9}, {
  3.9555008882932377`*^9, 3.955500893074835*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"55635d02-5c63-f643-8b92-94b087438901"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "6"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["S", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"4", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"3", " ", "S"}]}], ")"}], " ", "S"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", "S"}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", "S", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"11", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["c", "2"], " ", "S"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["b", "2"]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", "S"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"], "-", 
          RowBox[{"2", " ", "S"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"2", " ", "S"}]}], ")"}], " ", "S"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"], "-", 
        RowBox[{"2", " ", "S"}]}], ")"}], " ", "S", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"2", " ", "S"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "S"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"], "-", "S"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"8", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "-", "S"}], ")"}], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               SuperscriptBox["c", "2"]}], "+", 
              RowBox[{"11", " ", "S"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "2"], " ", "S", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{"3", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", "S"}], ")"}], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "8"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "6"], " ", "S"}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "17"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "22"}], " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "S", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"8", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"8", " ", "S"}]}], ")"}], " ", "S"}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"11", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["c", "2"], " ", "S"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "8"]}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["b", "8"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "4"], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "8"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "6"], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{"26", " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"10", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"23", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "4"], "+", 
              RowBox[{"8", " ", 
               SuperscriptBox["c", "2"], " ", "S"}], "-", 
              RowBox[{"30", " ", 
               SuperscriptBox["S", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["b", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"4", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "4"], " ", "S", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"8", " ", "S"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"30", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"8", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"51", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"28", " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "19"}], " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"2", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"8", " ", "S"}]}], ")"}], " ", "S"}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"29", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"10", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "20"}], " ", 
             SuperscriptBox["c", "4"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["c", "2"], " ", "S"}], "+", 
            RowBox[{"20", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["b", "8"]}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "-", "S"}], ")"}]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "6"], " ", "S"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"19", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "6"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "51"}], " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "-", 
            RowBox[{"4", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "S", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"8", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"15", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", "S", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "+", 
            RowBox[{"8", " ", "S"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"29", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"14", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "4"], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["c", "2"], " ", "S"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "8"]}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["b", "8"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}], "+", "S"}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "4"], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["c", "2"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "8"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"], " ", "S"}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "6"], "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{"30", " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "2"], "+", 
              RowBox[{"6", " ", "S"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"23", " ", 
               SuperscriptBox["c", "2"]}], "-", 
              RowBox[{"6", " ", "S"}]}], ")"}]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"], " ", "S"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["c", "4"], "+", 
              RowBox[{"8", " ", 
               SuperscriptBox["c", "2"], " ", "S"}], "-", 
              RowBox[{"26", " ", 
               SuperscriptBox["S", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "8"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "-", 
         RowBox[{"8", " ", "S"}]}], ")"}], " ", "S"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", "S"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"17", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "4"], " ", "S"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "S"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"4", " ", "S"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["c", "2"], "-", 
            RowBox[{"8", " ", "S"}]}], ")"}], " ", "S"}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"11", " ", 
             SuperscriptBox["c", "2"]}], "+", 
            RowBox[{"2", " ", "S"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"11", " ", 
             SuperscriptBox["c", "4"]}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["c", "2"], " ", "S"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.954729575891878*^9, 3.9547296012302666`*^9}, 
   3.954729646954029*^9, 3.954731759231823*^9, 3.954755116825212*^9, 
   3.955500632376896*^9, 3.955500803290745*^9, 3.9555008944723835`*^9, 
   3.961114762403467*^9, 3.9611147994369917`*^9, 3.961114898185276*^9, 
   3.961119008046995*^9, 3.961412594528027*^9},
 CellLabel->
  "Out[141]=",ExpressionUUID->"6a15e7a1-725f-4e17-8b6d-49cf86db4cbc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "FGHI", " ", "is", " ", "a", " ", "parallelogram", " ", "with", " ", 
    "IF"}], "||", " ", 
   RowBox[{"GH", " ", "and", " ", "IH"}], "||", " ", "GF"}], "*)"}]], "Input",
 CellChangeTimes->{{3.9611148401249323`*^9, 3.961114863887638*^9}, {
  3.9611189974519196`*^9, 3.9611189999536304`*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"029c0267-1472-274a-ae92-2ced4acd5843"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptI", ",", "ptF"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptH"}], "]"}], ",", 
   RowBox[{"equi", "&&", "ortho"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.954729807859654*^9, 3.954729824503559*^9}, {
  3.954755009211235*^9, 3.954755013394407*^9}, {3.9547550467536907`*^9, 
  3.954755057026333*^9}, {3.954755133083036*^9, 3.95475513477508*^9}, {
  3.955500671562372*^9, 3.955500706962506*^9}, {3.955500738637953*^9, 
  3.9555007555221214`*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"b9dfb52a-7b5a-554a-a9a3-5f7bdd2b5540"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.954755124252447*^9, 3.954755136469471*^9}, 
   3.955500708760023*^9, 3.9555007579103203`*^9, 3.955500924933317*^9, 
   3.961114802155058*^9, 3.961114901033207*^9, 3.961119011138281*^9, 
   3.9614125960527897`*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"3a119e6e-ebf2-46e1-a4c9-347423822a98"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptI", ",", "ptH"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptG"}], "]"}], ",", 
   RowBox[{"equi", "&&", "ortho"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9555009548352737`*^9, 3.9555009605464554`*^9}, {
  3.961114890719443*^9, 3.961114893728771*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"d1910d4f-68ba-814c-b0f7-ec2d7f92a07f"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.955500962309037*^9, 3.961114804213066*^9, 
  3.961114902849348*^9, 3.961119012711191*^9, 3.961412597535375*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"72a50af4-ac64-4788-b78f-019a89a514b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelogramQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.961118753754593*^9, 3.9611187660113945`*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"8655d8b2-c444-1846-9320-15fc35298116"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611187679020844`*^9, 3.961119024687586*^9, 
  3.961412600012562*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"6e45a872-dd64-41a3-8ff9-3be38b841b6c"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1294, 655},
WindowMargins->{{205, Automatic}, {Automatic, 61}},
FrontEndVersion->"14.2 for Mac OS X x86 (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2c987011-4232-1444-860d-88047ca04ba6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 484, 7, 96, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[1067, 31, 1485, 25, 164, "Text",ExpressionUUID->"22c83543-03f0-524a-b077-52bf40ea5d06"],
Cell[CellGroupData[{
Cell[2577, 60, 200, 4, 66, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[CellGroupData[{
Cell[2802, 68, 1808, 42, 131, "Input",ExpressionUUID->"74888ac6-8629-5b49-901d-61a6ce2212ce"],
Cell[4613, 112, 969, 25, 35, "Output",ExpressionUUID->"cfd51ebc-bbe5-4c04-a930-cd8f43dc74cb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5619, 142, 676, 19, 49, "Input",ExpressionUUID->"b85875b1-0f4d-224e-8941-3643f1b38130"],
Cell[6298, 163, 1407, 36, 33, "Output",ExpressionUUID->"4a33946f-97f1-420f-8fb0-57ddb229e215"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7742, 204, 2166, 61, 78, "Input",ExpressionUUID->"9b5c50c2-12e8-2e4e-a83c-2c0c274b0519"],
Cell[9911, 267, 1005, 25, 35, "Output",ExpressionUUID->"a29b3c23-e089-4808-aaf4-f79ed13a591a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10965, 298, 255, 4, 66, "Section",ExpressionUUID->"8108185d-0476-624f-aca1-9531401fcf8c"],
Cell[11223, 304, 8026, 217, 544, "Input",ExpressionUUID->"af857665-e69b-be41-831b-79c8778d303b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19286, 526, 211, 4, 66, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[19500, 532, 24337, 404, 113, "Text",ExpressionUUID->"27562332-302c-684c-a6e9-c7f5988655e4"],
Cell[CellGroupData[{
Cell[43862, 940, 515, 12, 29, "Input",ExpressionUUID->"92df2acf-ef77-6d4c-a144-72124269f2b6"],
Cell[44380, 954, 850, 24, 35, "Output",ExpressionUUID->"5fa46cb0-8b21-499a-af11-b98093368877"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45267, 983, 257, 4, 53, "Subsection",ExpressionUUID->"ecf6dcd3-cf0e-b645-870d-ac275961074f"],
Cell[CellGroupData[{
Cell[45549, 991, 359, 10, 29, "Input",ExpressionUUID->"241b988e-fc19-9b4b-a6d1-1396928f2f0b"],
Cell[45911, 1003, 836, 25, 35, "Output",ExpressionUUID->"eb9d6d0b-5579-4d48-908d-f8a328107238"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46784, 1033, 786, 18, 29, "Input",ExpressionUUID->"ef7de7f6-c2df-024e-ac07-6e9790b96d26"],
Cell[47573, 1053, 10528, 326, 148, "Output",ExpressionUUID->"2b3a6a3d-ec4b-4ec8-abdb-122677b3bfc5"]
}, Open  ]],
Cell[58116, 1382, 430, 10, 29, "Input",ExpressionUUID->"3e17e663-ee42-e74d-a24f-f535dfbc3639"],
Cell[CellGroupData[{
Cell[58571, 1396, 645, 14, 29, "Input",ExpressionUUID->"17b3a835-0e2e-9e4e-8891-bb03c169344a"],
Cell[59219, 1412, 422, 7, 33, "Output",ExpressionUUID->"19536fad-b198-4249-bf8b-e050683a1d01"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59678, 1424, 400, 10, 29, "Input",ExpressionUUID->"85d456ba-322b-b84d-9b69-1bb647470dfc"],
Cell[60081, 1436, 274, 5, 33, "Output",ExpressionUUID->"6eb70a26-9826-46b7-b624-9d9f255ebd92"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60392, 1446, 293, 6, 29, "Input",ExpressionUUID->"78fec985-6698-724b-913e-99ae9f85eb1e"],
Cell[60688, 1454, 180, 3, 33, "Output",ExpressionUUID->"8cb6e1d8-d3c5-43e3-89b8-9db8e300a39a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60917, 1463, 232, 4, 53, "Subsection",ExpressionUUID->"1ed5f139-668c-f64b-a46b-7ef4cdeadc1e"],
Cell[CellGroupData[{
Cell[61174, 1471, 684, 16, 29, "Input",ExpressionUUID->"55635d02-5c63-f643-8b92-94b087438901"],
Cell[61861, 1489, 24317, 722, 330, "Output",ExpressionUUID->"6a15e7a1-725f-4e17-8b6d-49cf86db4cbc"]
}, Open  ]],
Cell[86193, 2214, 432, 10, 29, "Input",ExpressionUUID->"029c0267-1472-274a-ae92-2ced4acd5843"],
Cell[CellGroupData[{
Cell[86650, 2228, 645, 14, 29, "Input",ExpressionUUID->"b9dfb52a-7b5a-554a-a9a3-5f7bdd2b5540"],
Cell[87298, 2244, 350, 6, 33, "Output",ExpressionUUID->"3a119e6e-ebf2-46e1-a4c9-347423822a98"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87685, 2255, 453, 11, 29, "Input",ExpressionUUID->"d1910d4f-68ba-814c-b0f7-ec2d7f92a07f"],
Cell[88141, 2268, 247, 4, 33, "Output",ExpressionUUID->"72a50af4-ac64-4788-b78f-019a89a514b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88425, 2277, 293, 6, 29, "Input",ExpressionUUID->"8655d8b2-c444-1846-9320-15fc35298116"],
Cell[88721, 2285, 205, 4, 33, "Output",ExpressionUUID->"6e45a872-dd64-41a3-8ff9-3be38b841b6c"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

